IF OBJECT_ID('P_EXP_CTB_MOV_TRANSF_LOJA_MATRIZ') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EXP_CTB_MOV_TRANSF_LOJA_MATRIZ
	END
 
GO
  
 
CREATE PROCEDURE P_EXP_CTB_MOV_TRANSF_LOJA_MATRIZ( @CD_EMP		INT,
												   @CD_FILIAL	INT,
												   @DT_INI		DATETIME,
												   @DT_FIM		DATETIME,
												   @FLAG_LIMPAR INT = 0)		
	
WITH ENCRYPTION AS  
SET NOCOUNT ON; 

BEGIN
	
	DECLARE @RS_CD_EMP				INT
	DECLARE @RS_CD_FILIAL			INT 		
	DECLARE @RS_DT_MOV				DATETIME					
	DECLARE @RS_VLR_DINHEIRO			MONEY
	DECLARE @RS_VLR_CHQ_VISTA		MONEY	
	DECLARE @NR_CONTROLE			VARCHAR (12)
	DECLARE @CD_CNT_CREDITO		VARCHAR(50)
	DECLARE @CD_CNT_CREDITO_RED		INT
	DECLARE @CD_CNT_DEBITO		VARCHAR(50)
	DECLARE @CD_CNT_DEBITO_RED		INT
	DECLARE @CD_GRP_ECON INT
	------------------------------------------------------------------------------------------------------------------------------
	--CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
	------------------------------------------------------------------------------------------------------------------------------
	EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV @FLAG_LIMPAR


	SET @CD_GRP_ECON = (SELECT PRC_GRP_ECON_PRC_FILIAL.CD_GRP_ECON
							FROM PRC_FILIAL
								INNER JOIN PRC_GRP_ECON_PRC_FILIAL ON
									PRC_FILIAL.CD_EMP = PRC_GRP_ECON_PRC_FILIAL.CD_EMP AND 
									PRC_FILIAL.CD_FILIAL = PRC_GRP_ECON_PRC_FILIAL.CD_FILIAL
							WHERE
							    PRC_FILIAL.CD_EMP 			= @CD_EMP
							    AND PRC_FILIAL.CD_FILIAL 	= @CD_FILIAL)
	
	
	DECLARE RS_RESULT
	CURSOR FOR 	
		SELECT
			@CD_EMP AS CD_EMP,
			CD_FILIAL,
			DT_MOV,
			SUM(VLR_DINHEIRO) - SUM(VLR_RECBTO_CREDIARIO)	AS VLR_DINHEIRO,
			SUM(VLR_CHQ_VISTA)	AS VLR_CHQ_VISTA
		FROM UFD_EXP_CTB_MOV_CAIXA(@CD_EMP, @CD_FILIAL, @DT_INI, @DT_FIM)
		--FROM UFD_EXP_CTB_MOV_CAIXA(1, 2, '20170201', '20170201')
		GROUP BY 
			CD_FILIAL,
			DT_MOV
		ORDER BY 			
			CD_FILIAL,
			DT_MOV
		

		--Abrindo cursor
		OPEN RS_RESULT
		
		--Atribuindo valores do select nas variveis
		FETCH NEXT FROM RS_RESULT INTO 
					@RS_CD_EMP,
					@RS_CD_FILIAL,
					@RS_DT_MOV,
					@RS_VLR_DINHEIRO,
					@RS_VLR_CHQ_VISTA	
					 

		--Iniciando lao
		WHILE @@FETCH_STATUS = 0
			BEGIN	

				
				
				/*Conta Crdito*/
				select @CD_CNT_CREDITO = BC.CD_CTB_CNT,
						@CD_CNT_CREDITO_RED = BC.CD_CTB_CNT_RED
				from PDV_VD_FECHA_MOV_TES TES
				INNER JOIN bc_contas BC on TES.CD_EMP = BC.CD_EMP AND BC.CD_CNT = TES.CD_CNT_CX
				WHERE TES.cd_filial = @RS_CD_FILIAL
				and TES.dt_mov = @RS_DT_MOV 
				and TES.cd_grp_econ = @CD_GRP_ECON

				/*Conta Dbito*/
				select @CD_CNT_DEBITO = BC_CONTAS.CD_CTB_CNT,
						@CD_CNT_DEBITO_RED = BC_CONTAS.CD_CTB_CNT_RED
				FROM BC_CONTAS, BC_CONTAS_PRC_GRP_ECON
				WHERE BC_CONTAS.CD_EMP = BC_CONTAS_PRC_GRP_ECON.CD_EMP AND
				  BC_CONTAS.CD_CNT = BC_CONTAS_PRC_GRP_ECON.CD_CNT AND
				  BC_CONTAS.CD_EMP = @RS_CD_EMP
				  AND BC_CONTAS_PRC_GRP_ECON.CD_GRP_ECON = @CD_GRP_ECON
				  AND BC_CONTAS.TP_CNT =0
				  AND BC_CONTAS.CNT_CX_PD=1
				  AND BC_CONTAS.STS_CNT=0
	
				 

				IF @RS_VLR_DINHEIRO > 0 				
					BEGIN             
						  ------------------------------------------------------------------------------------------------------------------
						  --DOACAO DEBITO - Ctb_Cnt_Caixa
						  ------------------------------------------------------------------------------------------------------------------
						  
						  --===== Tipos de Registros de movimento de vendas para cdigo de Controle usado no  Nmero de Documento ===================
						  --1 - dinheiro						  
						  --2 - cheque
						
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
								RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
								 RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
								  RIGHT('00'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),2)	+  '111'  -- 11 CD_MOVIMENTO 01 tipo de registro 

						  --===========================================================================================================================	
						  

						INSERT INTO ##CTB_EXP_MOV 
						
							 (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)
 
							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										11												AS CD_MOVIMENTO,
										'TRANSFERENCIA DE DINHEIRO DA LOJA P/ MATRIZ'	AS MOVIMENTO,
										''												AS OPERACAO,
										'TRANSFERENCIA DINHEIRO - DEBITO'				AS OPERACAO_DEBITO,
										0												AS CD_CNT_RED_CREDITO,
										''												AS CD_CNT_CREDITO,
										ISNULL(@CD_CNT_DEBITO_RED,0)					AS CD_CNT_RED_DEBITO,
										ISNULL(@CD_CNT_DEBITO,'')						AS CD_CNT_DEBITO,
										DATEADD(DAY, 1, @RS_DT_MOV)						AS DT_MOV,
										'VALOR REF. RECEBIMENTO DAS VENDAS DO DIA ' + CONVERT(VARCHAR(10), @RS_DT_MOV, 101) + ' (DINHEIRO)' AS HIST,								
										@RS_VLR_DINHEIRO								AS VLR_LANC,
										'D'												AS TP_TRANSA,
										0												AS RATEIO_CENTRO_CUSTO,
										''												AS DS_CENTRO_CUSTO,
										0												AS CNT_CENTRO_CUSTO,
										0												AS VLR_CENTRO_CUSTO,
										''												AS ORIG_CONTA,
										0												AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE	
										  , 'T' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , 0  AS NR_DP
										  , 0  AS ANO
										  , @NR_CONTROLE AS NR_DOC
										  , 0 AS CD_BC_LANC;
										
						------------------------------------------------------------------------------------------------------------------
						--DOACAO DEBITO - Ctb_Cnt_Caixa
						------------------------------------------------------------------------------------------------------------------
						INSERT INTO ##CTB_EXP_MOV  

								(CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										11												AS CD_MOVIMENTO,
										'TRANSFERENCIA DE DINHEIRO DA LOJA P/ MATRIZ'	AS MOVIMENTO,
										'TRANSFERENCIA DINHEIRO - CREDITO'				AS OPERACAO,
										''												AS OPERACAO_DEBITO,
										ISNULL(@CD_CNT_CREDITO_RED,0)					AS CD_CNT_RED_CREDITO,
										ISNULL(@CD_CNT_CREDITO,'')						AS CD_CNT_CREDITO,
										0												AS CD_CNT_RED_DEBITO,
										''												AS CD_CNT_DEBITO,
										DATEADD(DAY, 1, @RS_DT_MOV)						AS DT_MOV,
										'VALOR REF. RECEBIMENTO DAS VENDAS DO DIA ' + CONVERT(VARCHAR(10), @RS_DT_MOV, 101) + ' (DINHEIRO)' AS HIST,								
										@RS_VLR_DINHEIRO								AS VLR_LANC,
										'C'												AS TP_TRANSA,
										0												AS RATEIO_CENTRO_CUSTO,
										''												AS DS_CENTRO_CUSTO,
										0												AS CNT_CENTRO_CUSTO,
										0												AS VLR_CENTRO_CUSTO,
										''												AS ORIG_CONTA,
										0												AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE	
										  , 'T' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , 0  AS NR_DP
										  , 0  AS ANO
										  , @NR_CONTROLE AS NR_DOC
										  , 0 AS CD_BC_LANC;
					END


				IF @RS_VLR_CHQ_VISTA > 0 				
					
					BEGIN             
						------------------------------------------------------------------------------------------------------------------
						--DOACAO DEBITO - Ctb_Cnt_Caixa
						------------------------------------------------------------------------------------------------------------------

						--===== Tipos de Registros de movimento de vendas para codigo de Controle usado no  Nmero de Documento ===================
						  --1 - dinheiro						  
						  --2 - cheque
						
						  SET @NR_CONTROLE = RIGHT('000'+CAST(@RS_CD_FILIAL AS VARCHAR(3)),3) +  
								RIGHT('00'+ CAST( DAY( @RS_DT_MOV) AS VARCHAR),2) + 
								 RIGHT('00'+  CAST( MONTH(@RS_DT_MOV) AS VARCHAR),2) + 
								  RIGHT('000'+ CAST( YEAR(@RS_DT_MOV)AS VARCHAR),3)	+  '112'  -- 11 CD_MOVIMENTO 01 tipo de registro 

						  --===========================================================================================================================	


						INSERT INTO ##CTB_EXP_MOV  

							 (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										11												AS CD_MOVIMENTO,
										'TRANSFERENCIA DE CHEQUES DA LOJA P/ MATRIZ'	AS MOVIMENTO,
										''												AS OPERACAO,
										'TRANSFERENCIA CHEQUES - DEBITO'				AS OPERACAO_DEBITO,
										0												AS CD_CNT_RED_CREDITO,
										''												AS CD_CNT_CREDITO,
										0												AS CD_CNT_RED_DEBITO,
										''												AS CD_CNT_DEBITO,
										DATEADD(DAY, 1, @RS_DT_MOV)						AS DT_MOV,
										'VALOR REF. RECEBIMENTO DAS VENDAS DO DIA ' + CONVERT(VARCHAR(10), @RS_DT_MOV, 101) + ' (CHEQUE A VISTA)' AS HIST,								
										@RS_VLR_CHQ_VISTA								AS VLR_LANC,
										'D'												AS TP_TRANSA,
										0												AS RATEIO_CENTRO_CUSTO,
										''												AS DS_CENTRO_CUSTO,
										0												AS CNT_CENTRO_CUSTO,
										0												AS VLR_CENTRO_CUSTO,
										'MATRIZ'										AS ORIG_CONTA,
										14												AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE	
										 , 'T' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , 0  AS NR_DP
										  , 0  AS ANO
										  , @NR_CONTROLE AS NR_DOC
										  , 0 AS CD_BC_LANC;
										
						------------------------------------------------------------------------------------------------------------------
						--DOACAO DEBITO - Ctb_Cnt_Caixa
						------------------------------------------------------------------------------------------------------------------
						INSERT INTO ##CTB_EXP_MOV 
						
							(CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
							 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
							 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
							 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

						 
							SELECT		@RS_CD_EMP										AS CD_EMP,
										@CD_FILIAL										AS CD_FILIAL_EXPORT,
										@RS_CD_FILIAL									AS CD_FILIAL,
										11												AS CD_MOVIMENTO,
										'TRANSFERENCIA DE CHEQUES DA LOJA P/ MATRIZ'	AS MOVIMENTO,
										'TRANSFERENCIA CHEQUES - CREDITO'				AS OPERACAO,
										''												AS OPERACAO_DEBITO,
										0												AS CD_CNT_RED_CREDITO,
										''												AS CD_CNT_CREDITO,
										0												AS CD_CNT_RED_DEBITO,
										''												AS CD_CNT_DEBITO,
										DATEADD(DAY, 1, @RS_DT_MOV)						AS DT_MOV,
										'VALOR REF. RECEBIMENTO DAS VENDAS DO DIA ' + CONVERT(VARCHAR(10), @RS_DT_MOV, 101) + ' (CHEQUE A VISTA)' AS HIST,								
										@RS_VLR_CHQ_VISTA								AS VLR_LANC,
										'C'												AS TP_TRANSA,
										0												AS RATEIO_CENTRO_CUSTO,
										''												AS DS_CENTRO_CUSTO,
										0												AS CNT_CENTRO_CUSTO,
										0												AS VLR_CENTRO_CUSTO,
										'FILIAIS'										AS ORIG_CONTA,
										14												AS COD_CONTA,
										OBJECT_NAME(@@PROCID)							AS NM_PROCEDURE	
									    , 'T' AS TIPO_LANCTO
										  , 0 AS CD_EVENTO
										  , 0  AS NR_DP
										  , 0  AS ANO
										  , @NR_CONTROLE AS NR_DOC
										  , 0 AS CD_BC_LANC;
					END
					
		
				------------------------------------------------------------------------------------------------------------------
				--Prximo registro				
				------------------------------------------------------------------------------------------------------------------
				FETCH NEXT FROM RS_RESULT INTO 
						@RS_CD_EMP,
						@RS_CD_FILIAL,
						@RS_DT_MOV,
						@RS_VLR_DINHEIRO,
						@RS_VLR_CHQ_VISTA																

			END
		
		CLOSE RS_RESULT
		DEALLOCATE RS_RESULT	
END

 